/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ExternalStorageCacheFluid {
    private List<FluidStack> cache;

    public void update(INetwork network, @Nullable IFluidHandler handler) {
        int i;
        if (handler == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<FluidStack>();
            for (IFluidTankProperties properties : handler.getTankProperties()) {
                this.cache.add(properties.getContents() == null ? null : properties.getContents().copy());
            }
            return;
        }
        for (i = 0; i < handler.getTankProperties().length; ++i) {
            FluidStack actual = handler.getTankProperties()[i].getContents();
            if (i >= this.cache.size()) {
                if (actual == null) continue;
                network.getFluidStorageCache().add(actual, actual.amount, true);
                this.cache.add(actual.copy());
                continue;
            }
            FluidStack cached = this.cache.get(i);
            if (actual == null && cached == null) continue;
            if (actual == null) {
                network.getFluidStorageCache().remove(cached, cached.amount, true);
                this.cache.set(i, null);
                continue;
            }
            if (cached == null) {
                network.getFluidStorageCache().add(actual, actual.amount, true);
                this.cache.set(i, actual.copy());
                continue;
            }
            if (!API.instance().getComparer().isEqual(actual, cached, 2)) {
                network.getFluidStorageCache().remove(cached, cached.amount, true);
                network.getFluidStorageCache().add(actual, actual.amount, true);
                this.cache.set(i, actual.copy());
                continue;
            }
            if (actual.amount > cached.amount) {
                network.getFluidStorageCache().add(actual, actual.amount - cached.amount, true);
                cached.amount = actual.amount;
                continue;
            }
            if (actual.amount >= cached.amount) continue;
            network.getFluidStorageCache().remove(actual, cached.amount - actual.amount, true);
            cached.amount = actual.amount;
        }
        if (this.cache.size() > handler.getTankProperties().length) {
            for (i = this.cache.size() - 1; i >= handler.getTankProperties().length; --i) {
                FluidStack cached = this.cache.get(i);
                if (cached != null) {
                    network.getFluidStorageCache().remove(cached, cached.amount, true);
                }
                this.cache.remove(i);
            }
        }
        network.getFluidStorageCache().flush();
    }
}

